<?php 

/**
*                     .___     .__                   
*  _______   ____   __| _/_____|  |__   ____   ____  
*  \_  __ \_/ __ \ / __ |/  ___/  |  \ /  _ \_/ __ \ 
* 	|  | \/\  ___// /_/ |\___ \|   Y  (  <_> )  ___/ 
* 	|__|    \___  >____ /____  >___|  /\____/ \___  >
*         	    \/     \/    \/     \/            \/ 
* 	A deployment script for redbean
* 
* Copyright (c) 2009, Gabor De Mooij
All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:
    * Redistributions of source code must retain the above copyright
      notice, this list of conditions and the following disclaimer.
    * Redistributions in binary form must reproduce the above copyright
      notice, this list of conditions and the following disclaimer in the
      documentation and/or other materials provided with the distribution.
    * Neither the name of the Buurtnerd nor the
      names of its contributors may be used to endorse or promote products
      derived from this software without specific prior written permission.

THIS SOFTWARE IS PROVIDED BY Gabor De Mooij ''AS IS'' AND ANY
EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED. IN NO EVENT SHALL Gabor De Mooij BE LIABLE FOR ANY
DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/

//change this path if needed
$pathtooodb = "../redbean/RedBean/redbean.inc.php";

if (!file_exists($pathtooodb)) {
	echo "cannot find redbean \n"; exit;
}

function x( $text ) {
	echo "$text \n";
}

function lda() {
	
	if (file_exists("dbs.txt")) {
		$databases = file_get_contents("dbs.txt");	
	}
	else {
		$databases = "[]";
	}
	$databases = json_decode( $databases, true );
	return $databases;
}

function sv( $databases ) {
	file_put_contents( "dbs.txt", json_encode($databases) );
}

if (count($argv)<2) {
	
	x("Usage:");
	x("- to add a database to the list: ");
	x("redshoe add <databasetype> <host> <databasename> <user> <password> <key>");
	x("- to show the current list: ");
	x("redshoe list");
	x("- to prepare a deployment: ");
    x("redshoe deploy <src> <destinations>");
    x("- to run a deployment: ");
    x("redshoe distrib");
    x("- to export deployment SQL to files: ");
    x("redshoe export");
    exit;
}

if ($argv[1] == "remove") {

	if (isset($argv[2])) {
		$databases = lda();
		unset($databases[ $argv[2] ]);
		sv($databases);
		x("removed: ".$argv[2]);
	}
	
	exit;
}


if ($argv[1] == "add") {
	
	if (count($argv)==8) {
		
		$type = $argv[2];
		$host = $argv[3];
		$name = $argv[4];
		$user = $argv[5];
		$pass = $argv[6];
		$key = $argv[7];

		if ($pass=="-") {
			$pass="";
		}
		
		
		
		$databases = lda();
		
		
		if (isset($databases[$key])) {
			echo "\na database under this name already exists.\n";
			exit;
		}
		
		$databases[ $key ] = array(
			"type"=>$type,
			"host"=>$host,
			"name"=>$name,
			"user"=>$user,
			"pass"=>$pass,
			"key"=>$key
		); 
		
		sv( $databases );
		
		echo "done.\n";
		
	}
	
	exit;
}

if ($argv[1]=="list") {
	
	$databases = lda();
	foreach( $databases as $database ) {
		x( $database["key"] .": (". $database["type"].") '".$database["name"]."' on: ".$database["host"] );
	}
	exit;
}

if ($argv[1]=="deploy") {
	
	$databases = lda();
	require($pathtooodb);
	if (isset($databases[$argv[2]])) {
		extract($databases[$argv[2]]);
		$dsn = "mysql:host=$host;dbname=$name";
		
		x("source database: ".$key);
		$targets = array();
		$t = count($argv);
		for($i=3; $i<$t; $i++) {
			if ($databases[$argv[$i]]) {
				$targets[] = $databases[$argv[$i]];
				x("adding to target: ".$databases[$argv[$i]]["key"]);		
			}
		}
		x("targets:".count($targets));
		
		$info = array(
			"from" => array( "dsn"=> $dsn, "user"=>$user, "pass"=>$pass ),
			"to" => $targets
		);
		
		file_put_contents( "deploy.txt", json_encode( $info ) );
		x("Ready to deploy. To process this deployment run: php redshoe distrib");	
	}

	
}

if ($argv[1]=="distrib") {
		require($pathtooodb);	
		$info = json_decode( file_get_contents("deploy.txt"), true );
		$t = RedBean_Setup::kickstartDev( $info["from"]["dsn"], $info["from"]["user"], $info["from"]["pass"], true, "innodb", false);
		$targets = $info["to"];
		deploy($targets,1,$t);
	
}



if ($argv[1]=="export") {
		require($pathtooodb);	
		$info = json_decode( file_get_contents("deploy.txt"), true );
		$t = RedBean_Setup::kickstartDev( $info["from"]["dsn"], $info["from"]["user"], $info["from"]["pass"]);
		$targets = $info["to"];
		deploy($targets,2, $t);
}



function deploy( $targets, $mode=1 , RedBean_ToolBox $toolbox = NULL) {

$db = $toolbox->getDatabaseAdapter();
$schema=array();$create=array();$queries = array();$indexes=array();
$tables = $db->getCol("show tables");
foreach($tables as $table) {
	$schema[$table]=$db->get("describe `$table`");
	$create[$table]=$db->getRow("show create table `$table`");
	try{$indexes[$table]=$db->get("show index from `$table`");}catch(Exception $e){}
}


foreach($targets as $ti) {

	$queries = array();
	//print_r($schema);
	$target = new RedBean_DBAdapter( 
		new Redbean_Driver_PDO( "mysql:host=".$ti["host"].";dbname=".$ti["name"],$ti["user"],$ti["pass"])
		);
	$targettables = $target->getCol("show tables"); 
	
	foreach($schema as $table=>$def) {
		if (!in_array($table,$targettables)) {
			$queries[] = $create[$table]["Create Table"];
			
			
		}
		else {
			$fields = $schema[$table];
			$targetfields = $target->get("describe `$table`");
			
			foreach($fields as $field) {
				
				$found = false;
				foreach($targetfields as $targetfield) {
					if ($field["Field"]===$targetfield["Field"]) {
						$found = $targetfield;
					}
				}
	
				if (!$found) {
					//write sql
					$sql = "alter table `$table` add `".$field["Field"]."`
						".$field["Type"]."
					";
					
					$queries[] = $sql;
				}	
				else {
					if ($field["Type"]!=$found["Type"]) {
					//write sql
					$sql = "alter table `$table` change ".$found["Field"]."
						".$field["Field"]." 
						".$field["Type"]."
					";
					
					$queries[] = $sql;
					}
				}
				
			}
			
		}
		foreach($indexes as $tin=>$index) {
			if ($table===$tin) {
				try{$hasindex = $target->get("show index from `$table`");}catch(Exception $e){}
				foreach($index as $subindex) {
					if ($subindex["Column_name"]=="id") continue;
					$foundindex=0;
					foreach($hasindex as $thisindex) {
						if ($thisindex["Key_name"]===$subindex["Key_name"]) {
							$foundindex=1;
						}
					}
					if (!$foundindex) {
						$col = $subindex["Column_name"];
						$queries[] = "ALTER TABLE `$table` ADD INDEX(`$col`) ";
					}
				}
			}
		}
		
	}

	

	if ($mode===1) $target->exec( implode(';',$queries) ) ;
	if ($mode===2) file_put_contents( "import_".$ti["name"]."_".time().".sql", implode(';',$queries) );
}
	
}

